
export async function onRequest({ request, params, env }) {
    if (request.method === 'OPTIONS') {
        return new Response(null, {
            headers: {
                'Access-Control-Allow-Origin': '*',
                'Access-Control-Allow-Methods': 'GET, OPTIONS',
                'Access-Control-Allow-Headers': 'Content-Type',
                'Access-Control-Max-Age': '86400',
            },
        });
    }

    // 主页地址
    const remoteUrl = `https://cnb.cool/onedayxyy/hugo-teek/-/git/raw/dist/index.html`;

    const fetchResponse = await fetch(remoteUrl, {
        headers: {
            // 可以设置自定义 UA 或 referer，或者不设置（默认无 Referer）
            'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36',
            'Referer': remoteUrl, // 避免触发防盗链
        },
    });

    if (!fetchResponse.ok || !fetchResponse.body) {
        const res = JSON.stringify({
            success: false,
            message: '请求失败',
        });
        return new Response(res, {
            headers: {
                'content-type': 'application/json; charset=UTF-8',
                'Access-Control-Allow-Origin': '*',
            },
        });
    }

    return new Response(fetchResponse.body, {
        headers: {
            'Content-Type': 'text/html',
            'Access-Control-Allow-Origin': '*',
            'Cache-Control': 'public, max-age=3600',
        },
    });
}